% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{getMaxima}
\alias{getMaxima}
\title{Find the local maxima in a vector of numbers.}
\usage{
getMaxima(x, thresh_rel = 0.2)
}
\arguments{
\item{x}{Vector of numbers}

\item{thresh_rel}{Minimum relative intensity to maximum intensity of 'x' required
to be a maximum (i.e., a noise threshold). Default is 20\%.}
}
\value{
Vector of bool's, where TRUE indicates a local maximum.
}
\description{
A vector of booleans is returned with the same length as input (omitting NA's)
which contains TRUE when there is a maximum.
Simply sum up the vector to get the number of maxima.
}
\examples{
    r = getMaxima(c(1,0,3,4,5,0))                                
    all(r == c(TRUE,FALSE,FALSE,FALSE,TRUE,FALSE))
    
}

