% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plotTable}
\alias{plotTable}
\title{Plot a table with row names and title}
\usage{
plotTable(data, title = "", footer = "", col_names = colnames(data),
  fill = c("grey90", "grey70"), col = "black", just = "centre")
}
\arguments{
\item{data}{A data.frame with columns as described above}

\item{title}{Table title}

\item{footer}{Footer text}

\item{col_names}{Column names for Table}

\item{fill}{Fill pattern (by row)}

\item{col}{Text color (by column)}

\item{just}{(ignored)}
}
\value{
gTree object with class 'PTXQC_table'
}
\description{
Restriction: currently, the footer will be cropped at the table width.
}
\examples{
  data = data.frame(raw.file = letters[1:4],
                    id.rate = 3:6)
  plotTable(data, 
            title = "Bad files",
            footer = "bottom", 
            col_names = c("first col", "second col"),
            col=c("red", "green"))

}

