% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{peakWidthOverTime}
\alias{peakWidthOverTime}
\title{Discretize RT peak widths by averaging values per time bin.}
\usage{
peakWidthOverTime(data, RT_bin_width = 2)
}
\arguments{
\item{data}{Data.frame with columns 'retention.time' and 'retention.length'}

\item{RT_bin_width}{Bin size in minutes}
}
\value{
Data.frame with columns 'bin', 'RT', 'peakWidth'
}
\description{
Should be applied for each Raw file individually.
}
\details{
Returns a data.frame, where 'bin' gives the index of each bin, 'RT' is 
the middle of each bin and 'peakWidth' is the averaged peak width per bin.
}
\examples{
  data = data.frame(retention.time = seq(30,200, by=0.001)) ## one MS/MS per 0.1 sec
  data$retention.length = seq(0.3, 0.6, length.out = nrow(data)) + rnorm(nrow(data), 0, 0.1)
  d = peakWidthOverTime(data)
  plot(d$RT, d$peakWidth)
  
  
}

