% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_MS2Decal}
\alias{plot_MS2Decal}
\title{Plot bargraph of oversampled 3D-peaks.}
\usage{
plot_MS2Decal(data)
}
\arguments{
\item{data}{A data.frame with columns 'file', 'msErr', 'type'}
}
\value{
GGplot object
}
\description{
Per Raw file, at most three n's must be given, i.e.
the fraction of 3D-peaks for n=1, n=2 and n=3(or more).
The fractions must sum to 1 (=100%).
}
\examples{
  n = c(100, 130, 50)
  data = data.frame(file = repEach(paste(letters[1:3],"\\nLTQ [Da]"), n),
                    msErr = c(rnorm(n[1], 0.5), rnorm(n[2], 0.0), rnorm(n[3], -0.5)),
                    type = c("forward", "decoy")[1+(runif(sum(n))>0.95)])
  plot_MS2Decal(data)

}
