% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createYaml.R
\name{createYaml}
\alias{createYaml}
\title{Creates a yaml file storing the parameters that are used for creating the PTXQC report 
and returns these parameters as well as a list of available qc-Metrics objects.}
\usage{
createYaml(
  yc,
  param = list(),
  DEBUG_PTXQC = FALSE,
  txt_files = NULL,
  metrics = NULL
)
}
\arguments{
\item{yc}{A yaml class object created by YAMLClass$new()}

\item{param}{list of parameters sorted by names; if empty, will be populated with defaults}

\item{DEBUG_PTXQC}{print some debugging information; default FALSE}

\item{txt_files}{list of paths to MaxQuant files; if NULL, it is assumed that the parameters are for mzTab-mode}

\item{metrics}{list of metric names that should be plotted; if NULL, will be populated with defaults}
}
\value{
list of parameters used for creating the report and list of qc-Metrics objects
}
\description{
Valid parameters are: 
   param_useMQPAR, add_fs_col, id_rate_bad, id_rate_great , pg_ratioLabIncThresh , param_PG_intThresh,
   param_EV_protThresh , param_EV_intThresh, param_EV_pepThresh , yaml_contaminants, param_EV_MatchingTolerance,
   param_evd_mbr , param_EV_PrecursorTolPPM, param_EV_PrecursorOutOfCalSD , param_EV_PrecursorTolPPMmainSearch, 
   param_MSMSScans_ionInjThresh, param_OutputFormats and param_PageNumbers 
   
   Please provide them as a list() of this format: list$parameter_name
}
