% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designs_and_models.R
\name{calc_J}
\alias{calc_J}
\title{This function calculates needed J to achieve a given power}
\usage{
calc_J(
  d_m,
  MT = 2.8,
  MDES,
  K = NULL,
  nbar,
  Tbar,
  R2.1,
  R2.2,
  R2.3,
  ICC.2,
  ICC.3,
  omega.2,
  omega.3
)
}
\arguments{
\item{d_m}{a single RCT design (see list/naming convention)}

\item{MT}{Number of approximate effect-size unit SEs 
(adjusted for degrees of freedom issues) that the MDES 
needs to be to achieve desired power.  E.g., 2.8 for normal theory.}

\item{MDES}{scalar; the MDES values for each outcome}

\item{K}{scalar; the number of level 3 units (districts).}

\item{nbar}{scalar; the harmonic mean of the number of 
level 1 units per level 2 unit (students per school). 
Note that this is not the total number of level 1 units, 
but instead the number of level 1 units nested within 
each level 2 unit, so the total number of level 1 units
is nbar x J x K.}

\item{Tbar}{scalar; the proportion of samples 
that are assigned to the treatment.}

\item{R2.1}{scalar, or vector of length M; percent of variation explained by
level 1 covariates for each outcome.}

\item{R2.2}{scalar, or vector of length M; percent of variation explained by
level 2 covariates for each outcome.}

\item{R2.3}{scalar, or vector of length M; percent of variation explained by
level 3 covariates for each outcome.}

\item{ICC.2}{scalar, or vector of length M; 
level 2 (school) intraclass correlation.}

\item{ICC.3}{scalar, or vector length M; 
level 3 (district) intraclass correlation.}

\item{omega.2}{scalar, or vector of length M; ratio of 
variance of level 2 average impacts to
variance of level 2 random intercepts.}

\item{omega.3}{scalar, or vector of length M; ratio of 
variance of level 3 average impacts to
variance of level 3 random intercepts.}
}
\value{
J, the number of schools needed
}
\description{
This function calculates needed J to achieve a given power
}
\keyword{internal}
