% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fowlerguggenheimanalysis.r
\name{fowlerganalysis}
\alias{fowlerganalysis}
\title{Fowler-Guggenheim Isotherm Analysis Non-Linear Form}
\usage{
fowlerganalysis(theta, Ce, t)
}
\arguments{
\item{theta}{the numerical value for the surface coverage/fractional coverage}

\item{Ce}{the numerical value for the equilibrium capacity}

\item{t}{the numerical value for temperature in Kelvin}
}
\description{
Fowler-Guggenheim isotherm model describes as a case where there is mobile adsorption as well as lateral interaction among molecules.
}
\examples{
Ce <- c(0.39, 0.74, 1.19, 1.63, 2.03, 2.51, 2.96, 3.46, 3.9, 4.35)
theta <- c(0.051, 0.12, 0.14, 0.17, 0.21, 0.22, 0.24, 0.24, 0.27, 0.29)
fowlerganalysis(theta, Ce, 298)
}
\references{
Ayawei, N., Ebelegi, A.N., & Wankasi, D. (2017). Modelling and Interpretation of Adsorption Isotherms. Journal of Chemistry, 2017, 1-11. doi: 10.1155/2017/3039817

Qing Shao and Carol K Hall (2016). Protein adsorption on nanoparticles: model development using computer simulation. Journal of Physics: Condensed Matter

Oualid Hamdaouia, Emmanuel Naffrechoux (2007). Modeling of adsorption isotherms of phenol andchlorophenols onto granular activated carbonPart I. Two-parameter models and equations allowing determination of thermodynamic parameters
}
\author{
William Peter G. Sarmiento

Chester C. Deocaris
}
