% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed.lm.R
\name{bed.lm}
\alias{bed.lm}
\title{Linear Boyd External Diffusion Model}
\usage{
bed.lm(t, qt, qinf)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t. This parameter should not be greater than or equal to the other parameter 'qinf' as it will cause an incalculable value. Any row(s) that contain(s) a value greater than or equal to 'qe' will be automatically remove to proceed with the calculation.}

\item{qinf}{the numerical value for the amount adsorbed at infinite time}
}
\value{
the linear regression and the parameter estimation for the Boyd External Diffusion Model
}
\description{
The Boyd External Diffusion Model is frequently applied to adsorption kinetic data to calculate the rate constant, assuming that film diffusion is the rate-limiting step in the first few minutes of the adsorption process. The film diffusion has a strong dependency on agitation. Boyd’s diffusion models are used in numerous adsorption studies mostly to determine the rate-controlling step (Viegas, Campinas, Costa, and Rosa, 2014).
}
\examples{
t <- c(0,15,30,45,60,75,90,105,120)
qt <-c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qinf <- 4.68
bed.lm(t,qt,qinf)
}
\references{
Boyd, G. E., Adamson, A. W., & Myers, L. S. (1947) <doi:10.1021/ja01203a066> The Exchange Adsorption of Ions from Aqueous Solutions by Organic Zeolites. II. Kinetics1. Journal of the American Chemical Society, 69(11), 2836-2848.

Viegas, R. M. C., Campinas, M., Costa, H., &; Rosa, M. J. (2014) <doi:10.1007/s10450-014-9617-9> How do the HSDM and Boyd's model compare for estimating intraparticle diffusion coefficients in adsorption processes. Adsorption, 20(5-6), 737-746.
}
\author{
Jeff Ryan S. Magalong

Joshua Z. Dela Cruz

Jeann M. Bumatay

Chester C. Deocaris
}
