% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openaq_downloadData.R
\name{openaq_downloadData}
\alias{openaq_downloadData}
\title{Download and Aggregate Multiple Daily Data Files from OpenAQ}
\usage{
openaq_downloadData(parameter = NULL, startdate = "", days = 1,
  countryCode = NULL, baseUrl = "https://openaq-data.s3.amazonaws.com/")
}
\arguments{
\item{parameter}{pollutant name}

\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{days}{desired number of days of data to assemble}

\item{countryCode}{two-character country code (ISO 3166-1 alpha-2)}

\item{baseUrl}{base URL for data queries}
}
\value{
Dataframe of aggregated OpenAQ data.
}
\description{
This function downloads data from the OpenAQ Data Backups page
hosted on Amazon S3. All data obtained are then combined into a single dataframe
and returned.

Available parameters include:
\enumerate{
\item{pm25}{ -- PM2.5}
\item{pm10}{ -- PM10}
\item{o3}{ -- ozone }
\item{so2}{ -- sulfer dioxide }
\item{no2}{ -- nitrogen dioxide}
\item{co}{ -- carbon monoxide}
\item{bc}{ -- black carbon}
}
}
\examples{
\dontrun{
df <- openaq_downloadData(startdate=20160901, days=2)
}
}
\keyword{OpenAQ}

