% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_createMonitorObject.R
\name{wrcc_createMonitorObject}
\alias{wrcc_createMonitorObject}
\title{Obtain WRCC data and create ws_monitor object}
\usage{
wrcc_createMonitorObject(
  startdate = strftime(lubridate::now(tzone = "UTC"), "\%Y010100", tz = "UTC"),
  enddate = strftime(lubridate::now(tzone = "UTC"), "\%Y\%m\%d23", tz = "UTC"),
  unitID = NULL,
  clusterDiameter = 1000,
  zeroMinimum = TRUE,
  baseUrl = "https://wrcc.dri.edu/cgi-bin/wea_list2.pl",
  saveFile = NULL,
  existingMeta = NULL,
  addGoogleMeta = FALSE,
  addEsriMeta = FALSE,
  ...
)
}
\arguments{
\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{enddate}{desired end date (integer or character representing YYYYMMDD[HH])}

\item{unitID}{station identifier (will be upcased)}

\item{clusterDiameter}{diameter in meters used to determine the number of clusters (see \code{addClustering})}

\item{zeroMinimum}{logical specifying whether to convert negative values to zero}

\item{baseUrl}{base URL for data queries}

\item{saveFile}{optional filename where raw CSV will be written}

\item{existingMeta}{existing 'meta' dataframe from which to obtain metadata for known monitor deployments}

\item{addGoogleMeta}{logicial specifying wheter to use Google elevation and reverse geocoding services}

\item{addEsriMeta}{logicial specifying wheter to use ESRI elevation and reverse geocoding services}

\item{...}{additional parameters are passed to type-specific QC functions}
}
\value{
A \emph{ws_monitor} object with WRCC data.
}
\description{
Obtains monitor data from an WRCC webservice and converts
it into a quality controlled, metadata enhanced \emph{ws_monitor} object
ready for use with all \code{monitor_~} functions.

Steps involved include:

\enumerate{
 \item{download CSV text}
 \item{parse CSV text}
 \item{apply quality control}
 \item{apply clustering to determine unique deployments}
 \item{enhance metadata to include: elevation, timezone, state, country, site name}
 \item{reshape data into deployment-by-property \code{meta} and and time-by-deployment \code{data} dataframes}
}

QC parameters that can be passed in the \code{\dots} include the following
valid data ranges as taken from \code{wrcc_EBAMQualityControl()}:

\itemize{
\item{\code{valid_Longitude=c(-180,180)}}
\item{\code{valid_Latitude=c(-90,90)}}
\item{\code{remove_Lon_zero = TRUE}}
\item{\code{remove_Lat_zero = TRUE}}
\item{\code{valid_Flow = c(16.7*0.95,16.7*1.05)}}
\item{\code{valid_AT = c(-Inf,45)}}
\item{\code{valid_RHi = c(-Inf,45)}}
\item{\code{valid_Conc = c(-Inf,5000)}}
}

Note that appropriate values for QC thresholds will depend on the type of monitor.
}
\note{
The downloaded CSV may be saved to a local file by providing an argument to the \code{saveFile} parameter.
}
\examples{
\donttest{
library(PWFSLSmoke)
initializeMazamaSpatialUtils()

sm13 <- wrcc_createMonitorObject(20150301, 20150831, unitID = 'sm13')
monitor_leaflet(sm13)
}
}
\seealso{
\code{\link{wrcc_downloadData}}

\code{\link{wrcc_parseData}}

\code{\link{wrcc_qualityControl}}

\code{\link{addClustering}}

\code{\link{wrcc_createMetaDataframe}}

\code{\link{wrcc_createDataDataframe}}
}
\keyword{WRCC}
