% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_asDataframe.R
\name{monitor_asDataframe}
\alias{monitor_asDataframe}
\title{Return Monitor Data in a Single Dataframe}
\usage{
monitor_asDataframe(ws_monitor, monitorID = NULL, extraColumns = NULL,
  metaColumns = NULL, tlim = NULL)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{monitorID}{monitor ID of interest (not needed if \code{ws_monitor} contains only one monitor)}

\item{extraColumns}{optional vector of additional data columns to generate}

\item{metaColumns}{optional vector of column names from \code{ws_monitor$meta}}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH] or \code{POSIXct})}
}
\value{
A dataframe version of a \emph{ws_monitor} object.
}
\description{
Creates a dataframe with data from a \emph{ws_monitor} object, essentially 
\emph{flattening} the object. This is especially useful when monitoring data will be shared with
non-R users working with spreadsheets. The returned dataframe will contain data from the monitor
specified with \code{monitorID}.

The number of data columns in the returned dataframe can include all metadata as well
as additional calculated values.

By default, the following, core columns are included in the dataframe:
\itemize{
\item{\code{utcTime}}{ UTC datetime}
\item{\code{localTime}}{ local datetime}
\item{\code{pm25}}{ PM2.5 values in ug/m3}
}

Any column from \code{ws_monitor$meta} may be included in the vector of \code{metaColumns}.

The following additional columns of data may be included by adding one of the following
to the vector of \code{extraColumns{}}
\itemize{
\item{\code{aqi}}{ hourly AQI values as calculated with \code{monitor_aqi()}}
\item{\code{nowcast}}{ hourly Nowcast values as calcualted with \code{monitor_nowcast()}}
\item{\code{dailyAvg}}{ daily average PM2.5 values as calculated with \code{monitor_dailyStatistic()}}
}
}
\note{
The \code{tlim} argument is interpreted as localtime, not UTC.
}
\examples{
\dontrun{
wa <- monitor_subset(Northwest_Megafires, stateCodes='WA')
Omak_df <- monitor_asDataframe(wa, monitorID='530470013_01',
                               extraColumns=c('nowcast','dailyAvg'),
                               metaColumns=c('aqsID','siteName','timezone'),
                               tlim=c(20150801,20150901))
}
}
\seealso{
\code{\link{monitor_aqi}}

\code{\link{monitor_nowcast}}

\code{\link{monitor_dailyStatistic}}
}
\keyword{ws_monitor}
