% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_isTidy.R
\name{monitor_isTidy}
\alias{monitor_isTidy}
\title{Check if data is tidy-formatted ws_monitor data}
\usage{
monitor_isTidy(data = NULL)
}
\arguments{
\item{data}{Data to validate.}
}
\value{
True if the data is in a recognized 'Tidy' format, otherwise False.
}
\description{
Verifies that the given data can be treated as tidy-formatted "ws_monitor"
data. This is done by verifying that the data is a tibble data.frame object
with columns for information in all `ws_monitor` objects.
}
\examples{
ws_monitor <- monitor_subset(
  Northwest_Megafires,
  monitorIDs = c('530470009_01', '530470010_01')
)

ws_monTidy <- monitor_toTidy(ws_monitor)
monitor_isTidy(ws_monTidy)

\dontrun{
monitor_isTidy(ws_monitor)
}

}
