% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDependencies.R
\name{checkDependencies}
\alias{checkDependencies}
\title{checkDependencies}
\usage{
checkDependencies(
  repo,
  dependencyType = c("Imports", "Depends"),
  verbose = TRUE
)
}
\arguments{
\item{repo}{(\link[PaRe]{Repository})\cr
Repository object.}

\item{dependencyType}{(\link[base]{character})\cr
Types of dependencies to be included}

\item{verbose}{(\link[base]{logical}: TRUE)
TRUE or FALSE. If TRUE, progress will be reported.}
}
\value{
(\link[base]{data.frame})\cr
Data frame with all the packages that are now permitted.\tabular{ll}{
   column \tab data type \cr
   package \tab \link[base]{character} \cr
   version \tab \link[base]{character} \cr
}
}
\description{
Check package dependencies
}
\examples{
# Set cahce, usually not required.
withr::local_envvar(
  R_USER_CACHE_DIR = tempfile()
)

fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/tidyverse/glue.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  # Use checkDependencies on the Repository object.
  checkDependencies(repo)
  checkDependencies(repo, dependencyType = c("Imports", "Suggests"))
}
}
