% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_set_treatment_effects}
\alias{get_set_treatment_effects}
\title{get_set_treatment_effects}
\usage{
get_set_treatment_effects(pm.obj, data, lead)
}
\arguments{
\item{pm.obj}{an object of class \code{PanelMatch}}

\item{data}{data.frame with the original data}

\item{lead}{integer (or integer vector) indicating the time period(s) in the future for which the treatment effect size will be calculated. Calculations will be made for the period t + lead, where t is the time of treatment. If more than one lead value is provided, then calculations will be performed for each value.}
}
\description{
Calculates the treatment effect size at the matched set level
}
\details{
Calculate the size of treatment effects for each matched set.
}
\examples{

PM.results <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2",
                         treatment = "dem", refinement.method = "mahalanobis",
                         data = dem, match.missing = TRUE,
                         covs.formula = ~ I(lag(tradewb, 1:4)),
                         size.match = 5, qoi = "att",
                         outcome.var = "y", lead = 0:4, forbid.treatment.reversal = FALSE,
                         placebo.test = FALSE)
set.effects <- get_set_treatment_effects(pm.obj = PM.results, data = dem, lead = 0)


}
