% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptPath_getter.R
\name{getOptPathParetoFront}
\alias{getOptPathParetoFront}
\title{Get indices of pareto front of optimization path.}
\usage{
getOptPathParetoFront(
  op,
  y.names = op$y.names,
  dob = op$env$dob,
  eol = op$env$eol,
  index = FALSE
)
}
\arguments{
\item{op}{\link{OptPath}\cr
Optimization path.}

\item{y.names}{\link{character}\cr
Names of performance measures to construct pareto front for.
Default is all performance measures.}

\item{dob}{\link{integer}\cr
Vector of date-of-birth values to further subset the result.
Only elements with a date-of-birth included in \code{dob} are selected.
Default is all.}

\item{eol}{\link{integer}\cr
Vector of end-of-life values to further subset the result.
Only elements with an end-of-life included in \code{eol} are selected.
Default is all.}

\item{index}{(\code{logical(1)})\cr
Return indices into path of front or y-matrix of nondominated points?
Default is \code{FALSE}.}
}
\value{
\code{matrix} | \code{integer}. Either matrix (with named columns) of points of
front in objective space or indices into path for front.
}
\description{
Get indices of pareto front of optimization path.
}
\examples{
ps = makeParamSet(makeNumericParam("x"))
op = makeOptPathDF(par.set = ps, y.names = c("y1", "y2"), minimize = c(TRUE, TRUE))
addOptPathEl(op, x = list(x = 1), y = c(5, 3))
addOptPathEl(op, x = list(x = 2), y = c(2, 4))
addOptPathEl(op, x = list(x = 3), y = c(9, 4))
addOptPathEl(op, x = list(x = 4), y = c(4, 9))
as.data.frame(op)
getOptPathParetoFront(op)
getOptPathParetoFront(op, index = TRUE)
}
\seealso{
Other optpath: 
\code{\link{OptPath}},
\code{\link{addOptPathEl}()},
\code{\link{getOptPathBestIndex}()},
\code{\link{getOptPathCols}()},
\code{\link{getOptPathCol}()},
\code{\link{getOptPathDOB}()},
\code{\link{getOptPathEOL}()},
\code{\link{getOptPathEl}()},
\code{\link{getOptPathErrorMessages}()},
\code{\link{getOptPathExecTimes}()},
\code{\link{getOptPathLength}()},
\code{\link{getOptPathX}()},
\code{\link{getOptPathY}()},
\code{\link{setOptPathElDOB}()},
\code{\link{setOptPathElEOL}()}
}
\concept{optpath}
