% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParamNr.R
\name{getParamNr}
\alias{getParamNr}
\title{Return number of parameters in set.}
\usage{
getParamNr(par.set, devectorize = FALSE)
}
\arguments{
\item{par.set}{\link{ParamSet}\cr
Parameter set.}

\item{devectorize}{(\code{logical(1)})\cr
Sum over length of vector parameters?
Default is code{FALSE}.}
}
\value{
\code{\link{integer}}.
}
\description{
Either number of parameters or sum over parameter lengths.
}
\examples{
ps = makeParamSet(
  makeNumericParam("u"),
  makeDiscreteVectorParam("x", len = 2, values = c("a", "b"))
)
getParamNr(ps)
getParamNr(ps, devectorize = TRUE)
}
