% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getParamLengths}
\alias{getParamLengths}
\title{Return lengths of parameters in parameter set.}
\usage{
getParamLengths(par.set)
}
\arguments{
\item{par.set}{[\code{\link{ParamSet}}]\cr
Parameter set.}
}
\value{
[\code{integer}]. Named and in same order as \code{par.set}.
}
\description{
Useful for vector parameters.
}
\examples{
ps = makeParamSet(
  makeNumericParam("u"),
  makeIntegerParam("v", lower = 1, upper = 2),
  makeDiscreteParam("w", values = 1:2),
  makeDiscreteVectorParam("x", len = 2, values = c("a", "b"))
)
getParamLengths(ps)
# the length of the vector x is 2, for all other single value parameters the length is 1.
}

