% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPPModel.R
\name{PPP_Model}
\alias{PPP_Model}
\title{PPP_Model (Collective Panjer & Piecewise Pareto Model) Object}
\usage{
PPP_Model(
  FQ = NULL,
  t = NULL,
  alpha = NULL,
  truncation = NULL,
  truncation_type = "lp",
  dispersion = 1,
  Status = 0,
  Comment = "OK"
)
}
\arguments{
\item{FQ}{Numerical. Expected claim count of the collective model.}

\item{t}{Numeric vector. Vector containing the thresholds of the Piecewise Pareto distribution.}

\item{alpha}{Numeric vector. Vector containing the alphas of the Piecewise Pareto distribution.}

\item{truncation}{Numerical. If \code{truncation} is not \code{NULL} and \code{truncation > max(t)}, then the distribution is truncated at \code{truncation}.}

\item{truncation_type}{Character. If \code{truncation_type = "wd"} then the whole distribution is truncated. If \code{truncation_type = "lp"} then a truncated Pareto is used for the last piece.}

\item{dispersion}{Numerical. Dispersion of the Panjer distribution (i.e. variance to mean ratio).}

\item{Status}{Numerical indicator if a function returns a PPP_Model object: 0 = success, 1 = some information has been ignored, 2 = no solution found}

\item{Comment}{Charakter. An optional comment.}
}
\description{
Constructor function for the PPP_Model object
}
\examples{
PPPM <- PPP_Model(2, c(1000,2000), c(1,2), dispersion = 2)
PPPM

}
