% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_CDF}
\alias{Pareto_CDF}
\title{Distribution Function of the Pareto Distribution}
\usage{
Pareto_CDF(x, t, alpha, truncation = NULL)
}
\arguments{
\item{x}{Numeric. The function evaluates the CDF at \code{x}.}

\item{t}{Numeric. Threshold of the Pareto distribution.}

\item{alpha}{Numeric. Pareto alpha.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation}.}
}
\value{
Distribution function of the Pareto distribution with parameters \code{t} and \code{alpha} evaluated at \code{x}
}
\description{
Calculates the cumulative distribution function of a Pareto distribution. This function is deprecated. Use \code{pPareto} instead.
}
\examples{
x <- 0:10 * 1000
pPareto(x, 1000, 2)
pPareto(x, 1000, 2, truncation = 5000)

}
