% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_Find_Alpha_btw_FQs}
\alias{Pareto_Find_Alpha_btw_FQs}
\title{Pareto Alpha Between Two Frequencies}
\usage{
Pareto_Find_Alpha_btw_FQs(
  Threshold_1,
  Frequency_1,
  Threshold_2,
  Frequency_2,
  max_alpha = 100,
  tolerance = 1e-10,
  truncation = NULL
)
}
\arguments{
\item{Threshold_1}{Numeric. Threshold 1}

\item{Frequency_1}{Numeric. Expected frequency in excess of \code{Threshold_1}}

\item{Threshold_2}{Numeric. Threshold 2}

\item{Frequency_2}{Numeric. Expected frequency in excess of \code{Threshold_2}}

\item{max_alpha}{Numeric. Upper limit for the alpha that is returned.}

\item{tolerance}{Numeric. Accuracy of the result.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} then the Pareto distribution is truncated at \code{truncation}.}
}
\value{
The Pareto alpha between the expected number of claims \code{Frequency_1} excess \code{Threshold_1}
and the expected number of claims \code{Frequency_2} excess \code{Threshold_2}
}
\description{
Finds the Pareto alpha between two excess frequencies
}
\examples{
Pareto_Find_Alpha_btw_FQs(1000, 1, 2000, 0.5)
Pareto_Find_Alpha_btw_FQs(1000, 1, 2000, 0.5, truncation = 5000)

}
\references{
Riegel, U. (2018) Matching tower information with piecewise Pareto. European Actuarial Journal 8(2): 437--460
}
