% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{qPareto}
\alias{qPareto}
\title{Quantile Function of the Pareto Distribution}
\usage{
qPareto(p, t, alpha, truncation = NULL)
}
\arguments{
\item{p}{Numeric. The function evaluates the inverse CDF at \code{p}.}

\item{t}{Numeric. Threshold of the piecewise Pareto distribution.}

\item{alpha}{Numeric. Pareto alpha.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation}.}
}
\value{
Quantile function of the Pareto distribution with parameters \code{t} and \code{alpha}, evaluated at \code{p}
}
\description{
Calculates the quantile function of a Pareto distribution
}
\examples{
p <- 0:10 * 0.1
qPareto(p, 1000, 2)
qPareto(p, 1000, 2, truncation = 5000)

}
