% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceDecay.R
\name{linearDecay}
\alias{linearDecay}
\title{A simple linear decay function}
\usage{
linearDecay(x, signal = 1)
}
\arguments{
\item{x}{A numeric vector of distances (in [0,1]).}

\item{signal}{A single numeric value representing a signal.
\code{\link{weibullDecay}} and \code{\link{expDecay}} functions.}
}
\value{
A numeric vector; if missing 'x', it will return decay function.
}
\description{
The \code{linearDecay} function is used by PathwaySpace's
methods for signal convolution and projection.
}
\examples{
x <- seq(0, 2, 0.01)
y <- linearDecay(x, signal = 1)
plot(x, y)

}
\seealso{
\code{\link{weibullDecay}}, \code{\link{expDecay}}
}
\author{
Mauro Castro.
}
