% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addInObservation}
\alias{addInObservation}
\title{Indicate if a certain record is within the observation period}
\usage{
addInObservation(
  x,
  cdm = lifecycle::deprecated(),
  indexDate = "cohort_start_date",
  name = "in_observation"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{cdm}{A cdm_reference object.}

\item{indexDate}{Variable in x that contains the date to compute the
observation flag.}

\item{name}{name of the column to hold the result of the query:
1 if the individual is in observation, 0 if not}
}
\value{
cohort table with the added binary column assessing inObservation
}
\description{
Indicate if a certain record is within the observation period
}
\examples{
\donttest{
cdm <- mockPatientProfiles()
cdm$cohort1 \%>\%
  addInObservation()
}

}
