% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formattedTables.R
\name{formatCharacteristics}
\alias{formatCharacteristics}
\title{Format a summarised_characteristics object into a visual table.}
\usage{
formatCharacteristics(
  result,
  type = "gt",
  splitStrata = TRUE,
  format = c(`N (\%)` = "<count> (<percentage>\%)", N = "<count>",
    "<median> [<q25> - <q75>]", "<mean> (<sd>)", range = "<min> to <max>"),
  cdmName = TRUE,
  cohortName = TRUE,
  style = "default",
  minCellCount = 5,
  .options = list()
)
}
\arguments{
\item{result}{A summarised_characteristics object.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{splitStrata}{.}

\item{format}{.}

\item{cdmName}{.}

\item{cohortName}{.}

\item{style}{.}

\item{minCellCount}{.}

\item{.options}{.}
}
\value{
A tibble with a tidy version of the summarised_characteristics
object.
}
\description{
Format a summarised_characteristics object into a visual table.
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()

cdm$cohort1 |>
  summariseCharacteristics() |>
  formatCharacteristics()
}

}
