% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{assertNameStyle}
\alias{assertNameStyle}
\title{Assert whether a nameStyle contains the needed information.}
\usage{
assertNameStyle(nameStyle, values = list(), call = parent.frame())
}
\arguments{
\item{nameStyle}{nameStyle object to check.}

\item{values}{Parameters options that must be contained.}

\item{call}{An environment for cli functions.}
}
\value{
An error if nameStyle is not properly formatted.
}
\description{
Assert whether a nameStyle contains the needed information.
}
\examples{
\dontrun{
assertNameStyle("my_name", values = list(
  "variable1" = 1, "variable2" = c("a", "b", "c")
))

assertNameStyle("my_name_{variable2}", values = list(
  "variable1" = 1, "variable2" = c("a", "b", "c")
))

assertNameStyle("my_name_{variable2}", values = list(
  "variable1" = c(1, 2), "variable2" = c("a", "b", "c")
))

assertNameStyle("my_name_{variable1}_{variable2}", values = list(
  "variable1" = c(1, 2), "variable2" = c("a", "b", "c")
))
}

}
