% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseResult.R
\name{summariseResult}
\alias{summariseResult}
\title{Summarise variables using a set of estimate functions. The output will be
a formatted summarised_result object.}
\usage{
summariseResult(
  table,
  group = list(),
  includeOverallGroup = FALSE,
  strata = list(),
  includeOverallStrata = TRUE,
  variables = NULL,
  functions = lifecycle::deprecated(),
  estimates = c("min", "q25", "median", "q75", "max", "count", "percentage"),
  counts = TRUE
)
}
\arguments{
\item{table}{Table with different records.}

\item{group}{List of groups to be considered.}

\item{includeOverallGroup}{TRUE or FALSE. If TRUE, results for an overall
group will be reported when a list of groups has been specified.}

\item{strata}{List of the stratifications within each group to be considered.}

\item{includeOverallStrata}{TRUE or FALSE. If TRUE, results for an overall
strata will be reported when a list of strata has been specified.}

\item{variables}{Variables to summarise, it can be a list to point to different
set of estimate names.}

\item{functions}{deprecated.}

\item{estimates}{Estimates to obtain, it can be a list to point to different
set of variables.}

\item{counts}{Whether to compute number of records and number of subjects.}
}
\value{
A summarised_result object with the summarised data of interest.
}
\description{
Summarise variables using a set of estimate functions. The output will be
a formatted summarised_result object.
}
\examples{
\donttest{
library(PatientProfiles)
library(dplyr)

cdm <- mockPatientProfiles()
x <- cdm$cohort1 \%>\%
  addDemographics() \%>\%
  collect()
result <- summariseResult(x)
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
