% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographicsQuery.R
\name{addInObservationQuery}
\alias{addInObservationQuery}
\title{Query to add a new column to indicate if a certain record is within the
observation period}
\usage{
addInObservationQuery(
  x,
  indexDate = "cohort_start_date",
  window = c(0, 0),
  completeInterval = FALSE,
  nameStyle = "in_observation"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the
observation flag.}

\item{window}{window to consider events of.}

\item{completeInterval}{If the individuals are in observation for the full window.}

\item{nameStyle}{Name of the new columns to create, it must contain
"window_name" if multiple windows are provided.}
}
\value{
cohort table with the added binary column assessing inObservation.
}
\description{
`r lifecycle::badge("experimental")`
Same as `addInObservation()`, except query is not computed to a table.
}
\examples{
\donttest{
cdm <- mockPatientProfiles()
cdm$cohort1 \%>\%
  addInObservationQuery()
mockDisconnect(cdm = cdm)
}

}
