% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_matching_functions.R
\name{match_and_calculate_positions}
\alias{match_and_calculate_positions}
\title{Match peptide sequence with provided sequence and calculate positions}
\usage{
match_and_calculate_positions(
  peptide_data,
  column,
  whole_seq,
  match_columns,
  sequence_length = NULL,
  column_keep = NULL
)
}
\arguments{
\item{peptide_data}{A data frame containing peptide sequence information to match.}

\item{column}{The name of the column in peptide_data containing the peptide
sequences to be matched.}

\item{whole_seq}{A data frame containing details about antibody sequence
information including the domain and region information.
'Region_Sequence' column is required for the sequence information.
Change the column name if it is different than 'Region_Sequence'.}

\item{match_columns}{A character vector of column names to match on while
matching peptide sequence.}

\item{sequence_length}{(Optional) The sequence length range of peptide that
we want to keep in the result. (e.g. c(1, 5) will include
peptide sequence length from 1 to 5.)}

\item{column_keep}{(Optional) The name of the columns in peptide_data to
keep in result data frame.}
}
\value{
A data frame with columns from 'peptide_data' and 'whole_seq'
indicating the matched positions and related information.
}
\description{
This function matches peptide sequences from the 'peptide_data' data frame to
corresponding provided sequences in the 'whole_seq' data frame. It calculates
the start and end positions of the matched sequences and returns a data frame
with information about the matching positions.
}
\examples{
peptide_data <- data.frame(
  Sequence = c("AILNK", "BXLMR", "JJNXX", "DDEEF"),
  Condition_1 = c("Drug1", "Drug1", "Drug2", "Drug2"),
  Condition_2 = c("Donor1", "Donor2", "Donor1", "Donor2"),
  Region_1 = c("VH", "VL", "VH", "VL"),
  Region_2 = c("Arm_1", "Arm_2", "Arm_1", "Arm_2"),
  Area = c(100, 2, 4, NA)
)
whole_seq <- data.frame(
  Region_Sequence = c(
    "XYZAILNKPQR",
    "ABCBXLMRDEF",
    "GHIJJNXXKLM",
    "NOPDDEEFQRS",
    "AILXKPQR",
    "BNJLMRDEF",
    "ILNXXKLM",
    "DDEEXQRS",
    "XYZAAA",
    "XYZCCC",
    "XYZBBB",
    "XYZDDD",
    "XYZAAB",
    "XYZCCD",
    "XYZBBB",
    "XYZDDD"
  ),
  Condition_1 = c(
    "Drug1",
    "Drug1",
    "Drug2",
    "Drug2",
    "Drug1",
    "Drug1",
    "Drug2",
    "Drug2",
    "Drug1",
    "Drug1",
    "Drug2",
    "Drug2",
    "Drug1",
    "Drug1",
    "Drug2",
    "Drug2"
  ),
  Condition_2 = c(
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor1",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2",
    "Donor2"
  ),
  Region_1 = c(
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL",
    "VH",
    "VL"
  ),
  Region_2 = c(
    "Arm_1",
    "Arm_1",
    "Arm_1",
    "Arm_1",
    "Arm_2",
    "Arm_2",
    "Arm_2",
    "Arm_2",
    "Arm_1",
    "Arm_1",
    "Arm_1",
    "Arm_1",
    "Arm_2",
    "Arm_2",
    "Arm_2",
    "Arm_2"
  )
)
match_columns <- c("Condition_1", "Condition_2", "Region_1")
column_keep <- c("Region_2")
sequence_length <- c(1, 5)
column <- "Sequence"
matching_result <- match_and_calculate_positions(peptide_data,
                                                 column,
                                                 whole_seq,
                                                 match_columns,
                                                 sequence_length,
                                                 column_keep)

}
