% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocorrelation.R
\name{autoCorrelation}
\alias{autoCorrelation}
\title{Compute the auto-correlation index of a protein sequence}
\usage{
autoCorrelation(sequence, lag, property, center = TRUE)
}
\arguments{
\item{sequence}{An amino-acids sequence}

\item{lag}{A value for a lag, the max value is equal to the length of the shortest peptide minus one.}

\item{property}{A property to use as value to be correlated.}

\item{center}{A logical value \code{TRUE} or \code{FALSE} if the property must be centered.}
}
\value{
The computed auto-correlation index for a given amino-acids sequence
}
\description{
This function computes the Cruciani et al (2004) auto-correlation index. The \code{autoCorrelation} index is calculated for a lag 'd' using a descriptor 'f' (centred) over a sequence of length 'L'.
}
\examples{
# Loading a property to evaluate its autocorrelation
data(H)

# Calculate the auto-correlation index for a lag=1
autoCorrelation(
  sequence = "SDKEVDEVDAALSDLEITLE",
  lag = 1,
  property = H$KyteDoolittle,
  center = TRUE
)
# [1] -0.3519908

# Calculate the auto-correlation index for a lag=5
autoCorrelation(
  sequence = "SDKEVDEVDAALSDLEITLE",
  lag = 5,
  property = H$KyteDoolittle,
  center = TRUE
)
# [1] 0.001133553
}
\references{
Cruciani, G., Baroni, M., Carosati, E., Clementi, M., Valigi, R., and Clementi, S. (2004) Peptide studies by means of principal properties of amino acids derived from MIF descriptors. J. Chemom. 18, 146-155.
}
