% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kideraFactors.R
\name{kideraFactors}
\alias{kideraFactors}
\title{Compute the Kidera factors of a protein sequence}
\usage{
kideraFactors(seq)
}
\arguments{
\item{seq}{An amino-acids sequence}
}
\value{
A list with the average of the ten Kidera factors. 
The first four factors are essentially pure physical properties; the remaining six factors are superpositions of several physical properties, and are labelled for convenience by the name of the most heavily weighted component.
\itemize{\item{Helix/bend preference},
\item{Side-chain size},
\item{Extended structure preference},
\item{Hydrophobicity},
\item{Double-bend preference},
\item{Partial specific volume},
\item{Flat extended preference},
\item{Occurrence in alpha region},
\item{pK-C},
\item{Surrounding hydrophobicity}}
}
\description{
The Kidera Factors were originally derived by applying multivariate analysis to 188 physical properties of the 20 amino acids and using dimension reduction techniques. This function calculates the average of the ten Kidera factors for a protein sequence.
}
\examples{
kideraFactors(seq = "KLKLLLLLKLK")
# [[1]]
# helix.bend.pref      side.chain.size    extended.str.pref      
#   -0.78545455          0.29818182        -0.23636364          
# hydrophobicity     double.bend.pref     partial.spec.vol 
#   -0.08181818          0.21000000        -1.89363636 
# flat.ext.pref     occurrence.alpha.reg         pK.C       
#   1.02909091          -0.51272727          0.11181818    
# surrounding.hydrop 
#   0.81000000 
}
\references{
Kidera, A., Konishi, Y., Oka, M., Ooi, T., & Scheraga, H. A. (1985). Statistical analysis of the physical properties of the 20 naturally occurring amino acids. Journal of Protein Chemistry, 4(1), 23-55.
}
