\name{Inadequacy scale data}
\alias{InadequacyData}
\docType{data}
\title{The NPV-J inadequacy scale data}
\description{
The NPV-J (Dutch: Junior Nederlandse Persoonlijkheidsvragenlijst, NPV-J; Luteijn, van Dijk, and Barelds, 2005) is a large Dutch personality inventory. The NPV-J consists of 105 mostly positively formulated items and is intended to determine how adolescents between 9 and 15 years of age judge their own behavior. The NPV-J has five subscales; the \code{InadequacyScale} data concern scores of 806 adolescents on 28 items measuring inadequacy (one of the subscales). The data are dichotomous (0 = Disagree, 1 = Agree). The original sample consisted of 866 respondents, however 60 all-0s or all-1s response vectors were removed from the data. 
}
\usage{data(InadequacyData)}
\format{A 806x28 matrix of dichotomous item scores.}
\references{
Luteijn, F., van  Dijk, H., and Barelds, D. P. H. (2005) \emph{NPV-J: Junior Nederlandse Persoonlijkheidsvragenlijst.} Herziene handleiding 2005. Amsterdam: Harcourt Assessments B.V..

Meijer, R. R., and Tendeiro, J. N. (2012) The use of the lz and lz* person-fit statistics and problems derived from model misspecification. \emph{Journal of Educational and Behavioral Statistics}, \bold{37(6)}, 758--766. 
}
\examples{data(InadequacyData)}
\keyword{datasets}
