% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_phevis.R
\name{test_phevis}
\alias{test_phevis}
\title{test_phevis}
\usage{
test_phevis(
  train_param,
  df_test,
  surparam,
  model,
  START_DATE,
  PATIENT_NUM,
  ENCOUNTER_NUM
)
}
\arguments{
\item{train_param}{Parameters for the model training (variables used, main ICD and CUIS, half_life, gold standard, omega). Usually obtained from train_phevis() function.}

\item{df_test}{The dataframe on which to make the prediction.}

\item{surparam}{The parameters used to compute the surrogate. Usually obtained by train_phevis() function.}

\item{model}{The random intercept logistic regression. Usually obtained by train_phevis() function.}

\item{START_DATE}{Column name of the time column. The time column should be numeric}

\item{PATIENT_NUM}{Column name of the patient id column.}

\item{ENCOUNTER_NUM}{Column name of the encounter id column.}
}
\value{
A dataframe with the predictions.
}
\description{
test_phevis
}
\examples{
\donttest{library(dplyr)
library(PRROC)
PheVis::data_phevis
PheVis::data_perf

var_vec <- c(paste0("var",1:10), "mainCUI", "mainICD")
main_icd <- "mainICD"
main_cui <- "mainCUI"
GS <- "PR_state"
half_life <- Inf

df <- data_phevis \%>\%
        mutate(ENCOUNTER_NUM = row_number(),
               time = round(as.numeric(time)))

trainsize <- 0.8*length(unique(df$subject))
trainid <- sample(x = unique(df$subject), size = trainsize)
testid <- unique(df$subject)[!unique(df$subject) \%in\% trainid]

df_train <- as.data.frame(df[df$subject \%in\% trainid,])
df_test <- as.data.frame(df[df$subject \%in\% testid,])

##### train and test model #####
train_model <- PheVis::train_phevis(half_life = half_life,
                                    df = df_train,
                                    START_DATE = "time",
                                    PATIENT_NUM = "subject",
                                    ENCOUNTER_NUM = "ENCOUNTER_NUM",
                                    var_vec = var_vec,
                                    main_icd = main_icd,
                                    main_cui = main_cui)

test_perf <- PheVis::test_phevis(train_param = train_model$train_param,
                                 df_test = df_test,
                                 START_DATE = "time",
                                 PATIENT_NUM = "subject",
                                 ENCOUNTER_NUM = "ENCOUNTER_NUM",
                                 surparam = train_model$surparam,
                                 model = train_model$model)

pr_curve <-PRROC::pr.curve(scores.class0 = test_perf$df_result$PREDICTION,
                           weights.class0 = df_test$PR_state)

roc_curve <- PRROC::roc.curve(scores.class0 = test_perf$df_result$PREDICTION,
                              weights.class0 = df_test$PR_state)}

}
