% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenotypeDiagnostics.R
\name{phenotypeDiagnostics}
\alias{phenotypeDiagnostics}
\title{Phenotype a cohort}
\usage{
phenotypeDiagnostics(
  cohort,
  databaseDiagnostics = TRUE,
  codelistDiagnostics = TRUE,
  cohortDiagnostics = TRUE,
  populationDiagnostics = TRUE,
  populationSample = 1e+06,
  populationDateRange = as.Date(c(NA, NA)),
  matchedDiagnostics = TRUE,
  matchedSample = 1000
)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}

\item{databaseDiagnostics}{If TRUE, database diagnostics will be run.}

\item{codelistDiagnostics}{If TRUE, codelist diagnostics will be run.}

\item{cohortDiagnostics}{If TRUE, cohort diagnostics will be run.}

\item{populationDiagnostics}{If TRUE, population diagnostics will be run.}

\item{populationSample}{Number of people from the cdm to sample. If NULL no
sampling will be performed}

\item{populationDateRange}{Two dates. The first indicating the earliest cohort
start date and the second indicating the latest possible cohort end date. If
NULL or the first date is set as missing, the earliest observation_start_date
in the observation_period table will be used for the former. If  NULL or the
second date is set as missing, the latest observation_end_date in the
observation_period table will be used for the latter.}

\item{matchedDiagnostics}{If TRUE, cohort to population
diagnostics will be run.}

\item{matchedSample}{The number of people to take a random sample for
matching. If NULL, no sampling will be performed.}
}
\value{
A summarised result
}
\description{
This comprises all the diagnostics that are being offered in this package,
this includes:

* A diagnostics on the database via `databaseDiagnostics`.
* A diagnostics on the cohort_codelist attribute of the cohort via `codelistDiagnostics`.
* A diagnostics on the cohort via `cohortDiagnostics`.
* A diagnostics on the population via `populationDiagnostics`.
* A diagnostics on the matched cohort via `matchedDiagnostics`.
}
\examples{
\donttest{
cdm_local <- omock::mockCdmReference() |>
  omock::mockPerson(nPerson = 100) |>
  omock::mockObservationPeriod() |>
  omock::mockConditionOccurrence() |>
  omock::mockDrugExposure() |>
  omock::mockObservation() |>
  omock::mockMeasurement() |>
  omock::mockVisitOccurrence() |>
  omock::mockProcedureOccurrence() |>
  omock::mockCohort(name = "my_cohort")

  db <- DBI::dbConnect(duckdb::duckdb())
  cdm <- CDMConnector::copyCdmTo(con = db,
                                 cdm = cdm_local,
                                 schema ="main",
                                 overwrite = TRUE)
  phenotypeDiagnostics(cdm$my_cohort)
  CDMConnector::cdm_disconnect(cdm)
}
}
