% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyDiagnostics.R
\name{shinyDiagnostics}
\alias{shinyDiagnostics}
\title{Create a shiny app summarising your phenotyping results}
\usage{
shinyDiagnostics(
  result,
  directory,
  minCellCount = 5,
  open = rlang::is_interactive()
)
}
\arguments{
\item{result}{A summarised result}

\item{directory}{Directory where to save report}

\item{minCellCount}{Minimum cell count for suppression when exporting results.}

\item{open}{If TRUE, the shiny app will be launched in a new session. If
FALSE, the shiny app will be created but not launched.}
}
\value{
A shiny app
}
\description{
A shiny app that is designed for any diagnostics results from phenotypeR, this
includes:

* A diagnostics on the database via `databaseDiagnostics`.
* A diagnostics on the cohort_codelist attribute of the cohort via `codelistDiagnostics`.
* A diagnostics on the cohort via `cohortDiagnostics`.
* A diagnostics on the population via `populationDiagnostics`.
* A diagnostics on the matched cohort via `matchedDiagnostics`.
}
\examples{
\donttest{
library(PhenotypeR)

cdm <- mockPhenotypeR()

result <- phenotypeDiagnostics(cdm$my_cohort)

shinyDiagnostics(result, tempdir())

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
