% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateEM.R
\name{merge_rotations}
\alias{merge_rotations}
\title{Merge fits from independent runs of PhyloEM.}
\usage{
merge_rotations(..., method.selection = NULL, tol = NULL)
}
\arguments{
\item{...}{objects of class \code{\link{PhyloEM}} fitted on datasets that are equal up to a rotation.}

\item{method.selection}{(optional) selection method to be applied to the merged fit. 
See \code{\link{params_process.PhyloEM}}.}

\item{tol}{(optional) relative numerical tolerence. See \code{\link{find_rotation}}.}
}
\value{
An object of class \code{\link{PhyloEM}}, result of the merge.
}
\description{
\code{merge_rotations} takes several fits from \code{\link{PhyloEM}}, and
merge them according to the best score (maximum likelihood or least squares).
For each number of shifts, 
The datesets needs to be equal up to a rotation. This is tested thanks to a QR
decomposition, see function \code{\link{find_rotation}}.
}
\examples{
\dontrun{
## Load Data
data(monkeys)
## Run method
# Note: use more alpha values for better results.
res <- PhyloEM(Y_data = monkeys$dat,        ## data
               phylo = monkeys$phy,         ## phylogeny
               process = "scOU",            ## scalar OU
               random.root = TRUE,          ## root is stationary
               stationary.root = TRUE,
               K_max = 10,                  ## maximal number of shifts
               nbr_alpha = 4,               ## number of alpha values
               parallel_alpha = TRUE,       ## parallelize on alpha values
               Ncores = 2)
## Rotate dataset
rot <- matrix(c(cos(pi/4), -sin(pi/4), sin(pi/4), cos(pi/4)), nrow= 2, ncol = 2)
Yrot <- t(rot) \%*\% monkeys$dat
rownames(Yrot) <- rownames(monkeys$dat)
## Fit rotated dataset
# Note: use more alpha values for better results.
res_rot <- PhyloEM(Y_data = Yrot,               ## rotated data
                   phylo = monkeys$phy,         
                   process = "scOU",            
                   random.root = TRUE,          
                   stationary.root = TRUE,
                   K_max = 10,                  
                   nbr_alpha = 4,               
                   parallel_alpha = TRUE,       
                   Ncores = 2)
## Merge the two
res_merge <- merge_rotations(res, res_rot)
## Plot the selected result
plot(res_merge)
## Plot the model selection criterion
plot_criterion(res_merge)
}

}
