% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataCollapser.R
\name{dataCollapser}
\alias{dataCollapser}
\title{Collapse Accelerometer Data to a Dataset with a Longer Epoch}
\usage{
dataCollapser(dataset, TS, by, col, func = sum, ...)
}
\arguments{
\item{dataset}{The source dataset, in dataframe format, that needs to be
collapsed.}

\item{TS}{The column name for timestamp.}

\item{by}{Epoch in seconds for a collapsed dataset. For example, to collapse
second data to minute data, set by = 60; to collapse 10-second data to minute
data, set by = 60.}

\item{col}{The column name(s) to collapse.  If not provided, will default to
all numeric columns.}

\item{func}{A method for collapsing counts. The default is the summation of
counts.}

\item{\dots}{Argument settings that to be used by user-defined "func"
setting.}
}
\value{
A collapsed data with user specified epoch.
}
\description{
The function collapses counts in data collected with a short epoch to make a 
data set with a longer epoch. For example, this function collapses data with
1-sec epoch to 10-sec epoch or 1-min epoch data.
}
\examples{
data(dataSec)

## collapse 1-sec epoch data to 10-sec epoch data
mydata10s = dataCollapser(dataSec, TS = "TimeStamp", col = "counts", by = 10)

## collapse 1-sec epoch data to 1-min epoch data
mydata1m = dataCollapser(dataSec, TS = "TimeStamp", col = "counts", by = 60)
}
\references{
Choi L, Liu Z, Matthews CE, Buchowski MS. 
Validation of accelerometer wear and nonwear time classification algorithm.
Med Sci Sports Exerc. 2011 Feb;43(2):357-64.
}
\author{
Zhouwen Liu \email{zhouwen.liu@vumc.org}
}
