% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markingTime.R
\name{markingTime}
\alias{markingTime}
\title{Mark Days}
\usage{
markingTime(dataset, timestamp, startTime = "00:00:00", tz = "UTC")
}
\arguments{
\item{dataset}{The source dataset, in dataframe format, which needs to be
marked.}

\item{timestamp}{The column name in the dataset that will be used as
timestamp.}

\item{startTime}{Define the starting time of a day.  It must be in the format
of "hh:mm:ss".}

\item{tz}{Local time zone, defaults to UTC.}
}
\value{
A dataframe with an extra day marking column.
}
\description{
This function adds a "day" variable to the source dataset. The day is marked
in numeric order, according to the timestamp variable.
}
\references{
Choi L, Liu Z, Matthews CE, Buchowski MS. 
Validation of accelerometer wear and nonwear time classification algorithm.
Med Sci Sports Exerc. 2011 Feb;43(2):357-64.
}
\author{
Zhouwen Liu \email{zhouwen.liu@vumc.org}
}
