% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.rankings.R
\name{aggregate}
\alias{aggregate}
\alias{aggregate.rankings}
\alias{as.aggregated_rankings}
\alias{[.aggregated_rankings}
\alias{freq}
\title{Aggregate Rankings}
\usage{
\method{aggregate}{rankings}(x, freq = NULL, ...)

as.aggregated_rankings(x, ...)

\method{[}{aggregated_rankings}(x, i, j, ..., drop = FALSE,
  as.aggregated_rankings = TRUE)

freq(x)
}
\arguments{
\item{x}{A \code{\link[=rankings]{"rankings"}} object for \code{aggregate()}; an
object that can be coerced to a \code{"aggregated_rankings"} object for
\code{as.aggregated_rankings()}, otherwise an \code{"aggregated_rankings"} object.}

\item{freq}{A vector of frequencies for rankings that have been previously
aggregated.}

\item{...}{Additional arguments, currently unused.}

\item{i}{indices specifying rankings to extract, as for \code{\link{[}}.}

\item{j}{indices specifying items to extract, as for \code{\link{[}}.}

\item{drop}{if \code{TRUE} return single row/column matrices as a vector.}

\item{as.aggregated_rankings}{if \code{TRUE} create an
\code{"aggregated_rankings"} object from the indexed rankings. Otherwise index
the underlying matrix of ranks and return in a data frame with the
corresponding frequencies.}
}
\value{
A data frame of class \code{"aggregated_rankings"}, with columns
\item{ranking}{ A \code{\link[=rankings]{"rankings"}} object of the unique rankings.}
\item{freq}{The corresponding frequencies.}
Methods are available for \code{\link[=rbind]{rbind()}} and \code{\link[=as.matrix]{as.matrix()}}.
}
\description{
Aggregate rankings, returning an \code{"aggregated_rankings"} object of the
unique rankings and their frequencies. The frequencies can be extracted via
the function \code{freq()}.
}
\examples{
# create a rankings object with duplicated rankings
R <- matrix(c(1, 2, 0, 0,
              0, 1, 2, 3,
              2, 1, 1, 0,
              1, 2, 0, 0,
              2, 1, 1, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")
R <- as.rankings(R)

# aggregate the rankings
A <- aggregate(R)

# subsetting applies to the rankings, e.g. first two unique rankings
A[1:2]

# (partial) rankings of items 2 to 4 only
A[, 2:4]

# convert to a matrix
as.matrix(A)

# frequencies are automatically used as weights by PlackettLuce()
mod <- PlackettLuce(A)
mod$weights
}
\seealso{
\code{\link[=preflib]{preflib()}} for an object that can be coerced to an
\code{"aggregated_rankings"} object.
}
