% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbForests_PlotGraphs.R
\name{AbForests_PlotGraphs}
\alias{AbForests_PlotGraphs}
\title{Plot igraph and ggplot objects}
\usage{
AbForests_PlotGraphs(graphs, no_arg, topdf, filename)
}
\arguments{
\item{graphs}{a list of networks (Output of AntibodyForest function) or metrics (Output of ForestMetrics function).}

\item{no_arg}{element of list the user desires to plot : integer value,if the user desires to plot a metric and NULL, if the user desires to plot the networks.}

\item{topdf}{logical value, TRUE if user wants to store plots in pdf format (the no_arg element of each list is saved in a separate page of the pdf).}

\item{filename}{name of saved pdf file based on the user's preferences.}
}
\value{
Empty, output plots are written to file as specified by the user with the parameter filename
}
\description{
PlotGraphs takes as input the output of AntibodyForest or ForestMetrics functions and plots all corresponding networks in the single cell immune repertoire or the corresponding ggplot object, the user specifies, from all clone lineages.
The function gives the option in the user to store each tree or ggplot object within the repertoire in pdf format.
}
\examples{
\dontrun{
PlotGraphs(graphs,no_arg=NULL,topdf=TRUE,filename)
PlotGraphs(graphs,no_arg5,topdf=TRUE,filename)
}
}
\seealso{
AntibodyForest, ForestMetrics
}
