% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_bulk_to_vgm.R
\name{VDJ_bulk_to_vgm}
\alias{VDJ_bulk_to_vgm}
\title{Utility function for bulk data to standard Platypus format conversion}
\usage{
VDJ_bulk_to_vgm(
  VDJ.bulk.out.directory.list,
  input.type,
  integrate.MIXCR.output,
  vgm.expanded,
  clone.strategy,
  group.id,
  cell.type,
  batches,
  best.match.only
)
}
\arguments{
\item{VDJ.bulk.out.directory.list}{List containing paths to bulk VDJ output files from MIXCR or MAF.}

\item{input.type}{Character vector. Defaults to "MIXCR". "MIXCR" and "MAF" are supported.}

\item{integrate.MIXCR.output}{Boolean. Defaults to TRUE. Whether to include in the VGM output additional MiXCR (49-78) columns.}

\item{vgm.expanded}{Boolean. Defaults to TRUE. Whether to include vgm[[9]] in the output list, where vgm[[9]] is the expanded version of vgm[[1]] having 1 line per read. For some Platypus functions, only vgm[[9]] (and not vgm[[1]]) may be compatible.}

\item{clone.strategy}{Character vector to specify the clonotyping strategy. Defaults to "cdr3.aa". Note that MIXCR input comes with clonotypes already assigned, and therefore clone.strategy should be specified only when the user wants to change the clonoyping strategy, and if no clone.strategy is provided, re-clonotyping will not be performed. Meanwhile, MAF inputs do not come with the clonotypes pre-assigned. Hence, if no clone.strategy is specified, "cdr3.aa" will be used as the default clonotyping strategy. The clonotyping strategies available in this function are: "cdr3.aa", "VDJJ.VJJ", "VDJJ.VJJ.cdr3length".}

\item{group.id}{Numeric vector. Defaults to NA. The user can specify to which group does each file belong to (e.g. a group could correspond to some specific treatment). The length of this numeric vector should match the number of samples in the VDJ.bulk.out.directory.list input.}

\item{cell.type}{Character vector. Defaults to NA. Cell type (e.g., "Bcell") of the MIXCR or MAF file that is provided as input.}

\item{batches}{Numeric vector. Defaults to NA. An additional grouping parameter that can be specified by the user. The length of this numeric vector should match the number of samples in the VDJ.bulk.out.directory.list input.}

\item{best.match.only}{Boolean. Whether only the highest scoring gene (V,J,D,C gene should) should be included in the output, or all matching genes in MIXCR should be included (MAF outputs: for the same read we can only have one possible V,J,D or C gene). Defaults to TRUE.}
}
\value{
a VGM object (vgm.bulk.list). vgm.bulk.list[[1]]: each line correspond to a clonotype. vgm.bulk.list[[9]] (if vgm.expanded==TRUE): each line correspond to a read. The other (2-8) entries of the list are left empty for compatibility with Platypus functions.
}
\description{
The VDJ_bulk_to_vgm function converts bulk output files from MIXCR or MAF into
a vgm-format compatible with most downstream Platypus functions
used for VDJ repertoire analysis.
}
\examples{
\dontrun{
Run from local directory using MIXCR/MAF bulk VDJ-repertoire files as inputs:
VDJ.bulk.out.directory.list <- list()
VDJ.bulk.out.directory.list[[1]] <- c("~/MIXCR_vdj_cdr3_clonotyping/C4.txt")
VDJ.bulk.out.directory.list[[2]] <- c("~/MIXCR_vdj_cdr3_clonotyping/C6.txt")
bulk.vgm.MIXCR <- VDJ_bulk_to_vgm(VDJ.bulk.out.directory.list = VDJ.bulk.out.directory.list,
input.type = 'MIXCR',
integrate.MIXCR.output = TRUE,
group.id = c(1,2),
cell.type = "Bcells",
batches = c(1,1),
vgm.expanded = TRUE,
best.match.only = FALSE)

To re-clonotype MIXCR samples based on e.g., the CDR3 a.a. sequence:
bulk.vgm.MIXCR <- VDJ_bulk_to_vgm(VDJ.bulk.out.directory.list = VDJ.bulk.out.directory.list,
input.type = 'MIXCR',
integrate.MIXCR.output = TRUE,
group.id = c(1,2),
cell.type = "Bcells",
batches = c(1,1),
vgm.expanded = TRUE,
best.match.only = FALSE,
clone.strategy = "cdr3.aa")
}
}
