% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_logoplot_vector.R
\name{VDJ_logoplot_vector}
\alias{VDJ_logoplot_vector}
\title{Flexible logoplot wrapper}
\usage{
VDJ_logoplot_vector(cdr3.vector, length_cdr3, seq_type)
}
\arguments{
\item{cdr3.vector}{A character vector of aa sequences. This is to increase flexibility of this function. Such a sequence vector may be retrieved from the VDJ_analyse function output on a clonotype level or from the VDJ_GEX_matrix function output on a per cell level. Additionally, any length of sequence may be used (e.g. HCDR3 only or H and LCDR3 pasted together)}

\item{length_cdr3}{Integer or character. Defaults to "auto". Sets the length of the CDR3 regions that are selected to be plotted. If set to auto, the most frequently appearing length in the vector will be used}

\item{seq_type}{passed to ggseqlogo. Can be set to "aa", "dna", "rna" or "other"}
}
\value{
Returns the logo plot.
}
\description{
Plots a logoplot of the CDR3 aminoacid region
}
\examples{
VDJ_logoplot_vector(
cdr3.vector = Platypus::small_vgm[[1]]$VDJ_cdr3s_aa
,length_cdr3 = "auto",seq_type = "auto")

}
