% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_metrics.R
\name{AntibodyForests_metrics}
\alias{AntibodyForests_metrics}
\title{Node metrics for the AntibodyForests sequence similarity networks and minimum spanning trees.}
\usage{
AntibodyForests_metrics(
  trees,
  metrics,
  graph.type,
  features,
  exclude.intermediates,
  exclude.germline,
  separate.bipartite,
  parallel
)
}
\arguments{
\item{trees}{nested list of AntibodyForests objects or single object, as obtained from the AntibodyForests function.}

\item{metrics}{vector of strings - node metric to be calculated. Currently supported metrics include:
1. Betweenness centrality - 'betweenness'
2. Closeness centrality - 'closeness'
3. Eigenvector centrality - 'eigenvector'
4. Authority score - 'authority'
5. Local and average clustering coefficients - 'local_cluster_coefficient', 'average_cluster_coefficient'
6. Strength or weighted vertex degree - 'strength'
7. Degree - 'degree'
8. Daughter nodes for directed graphs - 'daughters'
9. Vertex eccentricity (shortest path distance from the farthest other node in the graph) - 'eccentricity'
10. Pagerank algorithm values - 'pagerank'
11. Shortest (weighted) paths from germline - 'path_from_germline', 'weighted_path_from_germline'
12. Shortest(weighted) paths from the most expanded node - 'path_from_most_expanded', 'weighted_path_from_most_expanded',
13. Shortest(weighted) paths from the hub node (highest degree) - 'path_from_hub', 'weighted_path_from_hub'}

\item{graph.type}{string - the graph type available in the AntibodyForests object which will be used as the function input.
Currently supported network/analysis types: 'tree' (for the minimum spanning trees or sequence similarity networks obtained from the main AntibodyForests function), 'heterogeneous' for the bipartite graphs obtained via AntibodyForests_heterogeneous, 'dynamic' for the dynamic networks obtained from AntibodyForests_dynamics.}

\item{features}{vector of strings - features to be considered when calculating whole-graph metrics (e.g., dominant/most abundant feature per graph).}

\item{exclude.intermediates}{boolean - if T, will not calculate the node-level metrics for the intermediate nodes obtained from AntibodyForests_expand_intermediates().}

\item{exclude.germline}{boolean - if T, will exclude the germline nodes from the node metric calculations.}

\item{separate.bipartite}{boolean - if T and graph.type = 'heterogeneous', will separate the cell and sequence graph and calculate the node metrics independently, then recombine them in the same final graph.}

\item{parallel}{boolean - whether to execute the main subroutine in parallel or not. Requires the 'parallel' R package to be installed.}
}
\value{
nested list of AntibodyForests objects or single AntibodyForests object, with a new class slot added (metrics) = a per-node dataframe of metric values.
}
\description{
Calculates several node metrics for the resulting AntibodyForests networks, adding these as a per-node dataframe in the new metrics slot. Must be called before AntibodyForests_plot_metrics.
}
\examples{
\dontrun{
AntibodyForests_metrics(trees, graph.type = 'tree', metrics = c('degree', 'pagerank'))
}
}
