% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_scaling_parameters.R
\name{Spatial_scaling_parameters}
\alias{Spatial_scaling_parameters}
\title{Scaling of the spatial parameters to be able to express the gene expression on the spatial image.}
\usage{
Spatial_scaling_parameters(vgm_spatial, GEX.out.directory.list, sample_names)
}
\arguments{
\item{vgm_spatial}{List containing the output of VDJ_GEX_matrix function from Platypus with at least the gene expression data and the addition of spatial parameters: image, scalefacor, tissue, cluster and matrix.}

\item{GEX.out.directory.list}{Path to the filtered feature bc matrix data.}

\item{sample_names}{Character vector containing the name of the sample.}
}
\value{
Returns a list containing all parameters to scale the data on the spatial image. List element [[1]]: images_cl. List element [[2]]: height of the image. List element [[3]]: width of the image. List element [[4]]: grobs. List element [[5]]: images_tibble. List element [[6]]: scales. List element [[7]]: cluster. List element [[8]]: bcs. List element [[9]]: matrix. List element [[10]]: bcs_merge.
}
\description{
Scaling of the spatial parameters to be able to express the gene expression on the spatial image.
}
\examples{
\dontrun{
scaling_parameters<-Spatial_scaling_parameters(vgm_spatial = vgm_spatial,
GEX.out.directory.list = GEX.out.directory.list,
sample_names = sample_names)
}
}
