% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulations.R
\name{compress_low_energy}
\alias{compress_low_energy}
\title{Compress Low-Energy Region}
\usage{
compress_low_energy(ftir_spectra_plot, cutoff = 2000, compression_ratio = 2)
}
\arguments{
\item{ftir_spectra_plot}{A plot generated by [plot_ftir()] or
  [plot_ftir_stacked()].

  Un tracé généré par [plot_ftir()] ou [plot_ftir_stacked()].}

\item{cutoff}{The wavenumber whereat those at lower energy will be
  compressed, but those above will be shown normally.

  Le nombre d'ondes où celles à faible énergie seront comprimées,
  mais celles au-dessus seront affichées normalement.}

\item{compression_ratio}{A numeric value indicating the ratio by which to
  squeeze the data

  Une valeur numérique indiquant le rapport selon lequel compresser les
  données}
}
\value{
the FTIR plot as a ggplot2 object, with x axis compressed for some
  wavenumber range

  le tracé IRTF en tant qu'objet ggplot2, avec l'axe des x comprimé pour
  une certaine gamme de nombres d'ondes
}
\description{
Compress the lower energy region of a FTIR plot (on the x axis) to
  leave more space for the higher-energy region. This is commonly done for
  wavenumbers higher than 2000 cm^-1 as the more complex spectra at higher
  energy (lower wavenumber) is harder to see clearly.

  Compressez la région de basse énergie d'un tracé d'IRTF (sur l'axe des x) pour
  laisser plus d'espace à la région de haute énergie. Cette opération
  généralement réalisée pour les nombres d'onde supérieurs à 2000 cm^-1, car
  les spectres plus complexes à houte énergie (nombre d'onde
  plus faible) sont plus difficiles à voir clairement.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  # Generate a plot
  biodiesel_plot <- plot_ftir(biodiesel)

  # Compress below 2000 cm^-1 by a factor of 5
  compress_low_energy(biodiesel_plot, cutoff = 2000, compression_ratio = 5)
}
}
