% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio_optimizer.R
\name{optim.portfolio}
\alias{optim.portfolio}
\title{Optimize portfolio weights}
\usage{
optim.portfolio(
  asset.names,
  increment = 100,
  rf = 0,
  period = c("months", "weeks", "quarters", "years")
)
}
\arguments{
\item{asset.names}{Vector of ticker of securities}

\item{increment}{Number of portfolio to be generated, Default: 100}

\item{rf}{Risk-free rate of return, Default: 0}

\item{period}{Period for which the returns are calculated, Default: c("months", "weeks", "quarters", "years")}
}
\value{
Returns a dataframe of the portfolios with different portfolio weights and different target returns and target standard deviation. Using this an investor can choose between range of portfolio to allocate funds.
}
\description{
Optimizes portfolio weights by minimizing the variance
}
\details{
Minimizes the variance using the method of lagrange multiplier to calculate the portfolio weights with minimized variance for given target return.
}
\examples{
optim.portfolio(c('FXAIX', 'TIBFX'), period = 'weeks')
}
