% Generated by roxygen2 (4.0.1): do not edit by hand
\name{optimize.portfolio.rebalancing}
\alias{optimize.portfolio.rebalancing}
\alias{optimize.portfolio.rebalancing_v1}
\title{Portfolio Optimization with Rebalancing Periods}
\usage{
optimize.portfolio.rebalancing_v1(R, constraints,
  optimize_method = c("DEoptim", "random", "ROI"), search_size = 20000,
  trace = FALSE, ..., rp = NULL, rebalance_on = NULL,
  training_period = NULL, rolling_window = NULL)

optimize.portfolio.rebalancing(R, portfolio = NULL, constraints = NULL,
  objectives = NULL, optimize_method = c("DEoptim", "random", "ROI"),
  search_size = 20000, trace = FALSE, ..., rp = NULL,
  rebalance_on = NULL, training_period = NULL, rolling_window = NULL)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of asset returns}

\item{portfolio}{an object of type "portfolio" specifying the constraints
and objectives for the optimization}

\item{constraints}{default NULL, a list of constraint objects}

\item{objectives}{default NULL, a list of objective objects}

\item{optimize_method}{one of "DEoptim", "random", "pso", "GenSA", or "ROI"}

\item{search_size}{integer, how many portfolios to test, default 20,000}

\item{trace}{TRUE/FALSE if TRUE will attempt to return additional
information on the path or portfolios searched}

\item{\dots}{any other passthru parameters to \code{\link{optimize.portfolio}}}

\item{rp}{a set of random portfolios passed into the function to prevent recalculation}

\item{rebalance_on}{character string of period to rebalance on. See
\code{\link[xts]{endpoints}} for valid names.}

\item{training_period}{an integer of the number of periods to use as
a training data in the front of the returns data}

\item{rolling_window}{an integer of the width (i.e. number of periods)
of the rolling window, the default of NULL will run the optimization
using the data from inception.}
}
\value{
a list containing the following elements
\itemize{
  \item{\code{portfolio}:}{ The portfolio object.}
  \item{\code{R}:}{ The asset returns.}
  \item{\code{call}:}{ The function call.}
  \item{\code{elapsed_time:}}{ The amount of time that elapses while the
  optimization is run.}
  \item{\code{opt_rebalancing:}}{ A list of \code{optimize.portfolio}
  objects computed at each rebalancing period.}
}
}
\description{
Portfolio optimization with support for rebalancing periods for
out-of-sample testing (i.e. backtesting)
}
\details{
Run portfolio optimization with periodic rebalancing at specified time periods.
Running the portfolio optimization with periodic rebalancing can help
refine the constraints and objectives by evaluating the out of sample
performance of the portfolio based on historical data

This function is a essentially a wrapper around \code{optimize.portfolio}
and thus the discussion in the Details section of the
\code{\link{optimize.portfolio}} help file is valid here as well.

This function is massively parallel and requires the 'foreach' package. It
is suggested to register a parallel backend.
}
\examples{
\dontrun{
data(edhec)
R <- edhec[,1:4]
funds <- colnames(R)

portf <- portfolio.spec(funds)
portf <- add.constraint(portf, type="full_investment")
portf <- add.constraint(portf, type="long_only")
portf <- add.objective(portf, type="risk", name="StdDev")

# Quarterly rebalancing with 5 year training period
bt.opt1 <- optimize.portfolio.rebalancing(R, portf,
optimize_method="ROI",
rebalance_on="quarters",
training_period=60)

# Monthly rebalancing with 5 year training period and 4 year rolling window
bt.opt2 <- optimize.portfolio.rebalancing(R, portf,
optimize_method="ROI",
rebalance_on="months",
training_period=60,
rolling_window=48)
}
}
\author{
Kris Boudt, Peter Carl, Brian G. Peterson
}
\seealso{
\code{\link{portfolio.spec}} \code{\link{optimize.portfolio}}
}

