/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.openfast.Global;
import org.openfast.NumericValue;
import org.openfast.error.FastConstants;

public class DecimalValue
extends NumericValue {
    private static final long serialVersionUID = 1L;
    public final int exponent;
    public final long mantissa;

    public DecimalValue(double value) {
        if (value == 0.0) {
            this.exponent = 0;
            this.mantissa = 0L;
            return;
        }
        BigDecimal decimalValue = BigDecimal.valueOf(value);
        int exponent = decimalValue.scale();
        long mantissa = decimalValue.unscaledValue().longValue();
        while (mantissa % 10L == 0L && mantissa != 0L) {
            mantissa /= 10L;
            --exponent;
        }
        this.mantissa = mantissa;
        this.exponent = -exponent;
    }

    public DecimalValue(long mantissa, int exponent) {
        this.mantissa = mantissa;
        this.exponent = exponent;
    }

    public DecimalValue(BigDecimal bigDecimal) {
        this.mantissa = bigDecimal.unscaledValue().longValue();
        this.exponent = -1 * bigDecimal.scale();
    }

    public NumericValue increment() {
        return null;
    }

    public NumericValue decrement() {
        return null;
    }

    public Object toObject() {
        return this.toBigDecimal();
    }

    public boolean isNull() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DecimalValue)) {
            return false;
        }
        return this.equals((DecimalValue)obj);
    }

    public boolean equals(DecimalValue other) {
        return other.mantissa == this.mantissa && other.exponent == this.exponent;
    }

    public NumericValue subtract(NumericValue subtrahend) {
        return new DecimalValue(this.toBigDecimal().subtract(((DecimalValue)subtrahend).toBigDecimal()));
    }

    public NumericValue add(NumericValue addend) {
        return new DecimalValue(this.toBigDecimal().add(((DecimalValue)addend).toBigDecimal()));
    }

    public String serialize() {
        return this.toString();
    }

    public boolean equals(int value) {
        return false;
    }

    public long toLong() {
        if (this.exponent < 0) {
            Global.handleError(FastConstants.R5_DECIMAL_CANT_CONVERT_TO_INT, "");
        }
        return this.getValue();
    }

    public int toInt() {
        long value = this.getValue();
        if (this.exponent < 0 || value > Integer.MAX_VALUE) {
            Global.handleError(FastConstants.R5_DECIMAL_CANT_CONVERT_TO_INT, "");
        }
        return (int)value;
    }

    public short toShort() {
        long value = this.getValue();
        if (this.exponent < 0 || value > 32767L) {
            Global.handleError(FastConstants.R5_DECIMAL_CANT_CONVERT_TO_INT, "");
        }
        return (short)value;
    }

    public byte toByte() {
        long value = this.getValue();
        if (this.exponent < 0 || value > 127L) {
            Global.handleError(FastConstants.R5_DECIMAL_CANT_CONVERT_TO_INT, "");
        }
        return (byte)value;
    }

    private long getValue() {
        return this.mantissa * (long)Math.pow(10.0, this.exponent);
    }

    public double toDouble() {
        return (double)this.mantissa * Math.pow(10.0, this.exponent);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(BigInteger.valueOf(this.mantissa), -this.exponent);
    }

    public String toString() {
        return this.toBigDecimal().toPlainString();
    }

    public int hashCode() {
        return this.exponent * 37 + (int)this.mantissa;
    }
}

