/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.scp10;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.openfast.examples.Assert;
import org.openfast.examples.OpenFastExample;
import org.openfast.examples.scp10.ScpMessageProducer;
import org.openfast.session.FastConnectionException;
import org.openfast.session.tcp.TcpEndpoint;

public class Main
extends OpenFastExample {
    private static Options options = new Options();

    static {
        options.addOption("?", "help", false, "Displays this message");
        options.addOption("p", "port", true, "Port to serve data on");
        options.addOption("h", "host", true, "The host name of the server");
        options.addOption("e", "error", false, "Show stacktrace information");
        options.addOption("t", "template", true, "Message template definition file");
        options.addOption("x", "xml", true, "The XML data to convert to FAST");
    }

    public static void main(String[] args) {
        CommandLine cl = Main.parseCommandLine("scp10producer", args, options);
        if (cl.hasOption("help")) {
            Main.displayHelp("scp10producer", options);
        }
        TcpEndpoint endpoint = null;
        boolean showStacktrace = cl.hasOption("error");
        File templatesFile = null;
        File xmlDataFile = null;
        try {
            Assert.assertTrue(cl.hasOption("port"), "The required parameter \"port\" is missing.");
            int port = Main.getInteger(cl, "port");
            String host = cl.hasOption("host") ? cl.getOptionValue("host") : "localhost";
            endpoint = new TcpEndpoint(host, port);
            templatesFile = Main.getFile(cl, "template");
            xmlDataFile = Main.getFile(cl, "xml");
            Assert.assertTrue(templatesFile.exists(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!templatesFile.isDirectory(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(templatesFile.canRead(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is not readable.");
            Assert.assertTrue(templatesFile.exists(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!templatesFile.isDirectory(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(templatesFile.canRead(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is not readable.");
        }
        catch (AssertionError e) {
            System.out.println(((Throwable)((Object)e)).getMessage());
            Main.displayHelp("consumer", options);
        }
        ScpMessageProducer producer = new ScpMessageProducer(endpoint, templatesFile);
        try {
            producer.start(xmlDataFile);
            producer.stop();
        }
        catch (FastConnectionException e) {
            if (showStacktrace) {
                e.printStackTrace();
            }
            System.out.println("Unable to connect to endpoint: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            if (showStacktrace) {
                e.printStackTrace();
            }
            System.out.println("An IO error occurred while consuming messages: " + e.getMessage());
            System.exit(1);
        }
    }
}

