/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.tmplexch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.openfast.examples.Assert;
import org.openfast.examples.OpenFastExample;
import org.openfast.examples.tmplexch.TemplateExchangeDefinitionDecoder;

public class DecodeMain
extends OpenFastExample {
    private static Options options = new Options();

    static {
        options.addOption("?", "help", false, "Displays this message");
        options.addOption("e", "error", false, "Show stacktrace information");
        options.addOption("n", "ns", false, "Enables namespace awareness");
        options.addOption("t", "template", true, "Output message template definition file");
        options.addOption("f", "data", true, "FAST Encoded Template Exchange file");
    }

    public static void main(String[] args) {
        CommandLine cl = DecodeMain.parseCommandLine("consumer", args, options);
        if (cl.hasOption("help")) {
            DecodeMain.displayHelp("consumer", options);
        }
        boolean showStacktrace = cl.hasOption("error");
        File templatesFile = null;
        OutputStream out = System.out;
        if (cl.hasOption("template")) {
            try {
                templatesFile = DecodeMain.getFile(cl, "template");
                Assert.assertTrue(!templatesFile.isDirectory(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is a directory.");
                if (!templatesFile.exists()) {
                    templatesFile.createNewFile();
                }
                Assert.assertTrue(templatesFile.exists(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" does not exist.");
                out = new FileOutputStream(templatesFile);
            }
            catch (AssertionError e) {
                System.out.println(((Throwable)((Object)e)).getMessage());
                DecodeMain.displayHelp("consumer", options);
            }
            catch (FileNotFoundException e) {
                System.out.println("Unable to create output file.");
                System.exit(1);
            }
            catch (IOException e) {
                System.out.println("Unable to create output file.");
                System.exit(1);
            }
        }
        InputStream fastIn = null;
        try {
            File inFile = DecodeMain.getFile(cl, "data");
            if (!inFile.exists()) {
                inFile.createNewFile();
            }
            Assert.assertTrue(inFile.exists(), "The fast encoded data file \"" + inFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!inFile.isDirectory(), "The fast encoded data file \"" + inFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(inFile.canRead(), "The fast encoded data file \"" + inFile.getAbsolutePath() + "\" is not readable.");
            fastIn = new FileInputStream(inFile);
        }
        catch (FileNotFoundException e) {
            System.out.println("Unable to open data file.");
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Unable to open data file.");
            System.exit(1);
        }
        TemplateExchangeDefinitionDecoder tmplExchanger = new TemplateExchangeDefinitionDecoder(fastIn, cl.hasOption("ns"), out);
        try {
            try {
                tmplExchanger.start();
                if (cl.hasOption("template")) {
                    System.out.println("Templates written to " + templatesFile.getAbsolutePath() + ".");
                }
            }
            catch (IOException e) {
                if (showStacktrace) {
                    e.printStackTrace();
                }
                System.out.println("An IO error occurred while consuming messages: " + e.getMessage());
                System.exit(1);
                try {
                    out.flush();
                    out.close();
                    fastIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                out.flush();
                out.close();
                fastIn.close();
            }
            catch (IOException iOException) {}
        }
    }
}

