/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import java.lang.reflect.Type;
import java.util.HashMap;

public class EstimatorData {
    private HashMap<String, String> settings;
    private long dataId;
    private ArrayCache indexPrice;
    private ArrayCache indexTimeMillisec;
    private long priceID;

    public EstimatorData(EstimatorData data) {
        this.indexPrice = data.indexPrice;
        this.indexTimeMillisec = data.indexTimeMillisec;
        this.dataId = data.dataId;
        this.priceID = data.priceID;
        this.settings = new HashMap<String, String>(data.settings);
        this.settings.put("portfolioId", "" + ClientConnection.getNewId());
    }

    public EstimatorData() {
        this.settings = new HashMap();
        this.settings.put("fromTime", "#");
        this.settings.put("toTime", "#");
        this.dataId = 0L;
        this.settings.put("portfolioId", "" + ClientConnection.getNewId());
        this.indexPrice = null;
        this.indexTimeMillisec = null;
        this.priceID = 0L;
    }

    public String getIndexSymbol() {
        return this.settings.get("indexSymbol");
    }

    public void setIndexSymbol(String indexSymbol) {
        this.settings.put("indexSymbol", indexSymbol);
    }

    public String getFromTime() {
        return this.settings.get("fromTime");
    }

    public void setFromTime(String fromTime) {
        this.settings.put("fromTime", fromTime);
    }

    public String getToTime() {
        return this.settings.get("toTime");
    }

    public void setToTime(String toTime) {
        this.settings.put("toTime", toTime);
    }

    public long getDataId() {
        return this.dataId;
    }

    public void setDataId(int dataId) {
        this.dataId = dataId;
    }

    public long getPortfolioId() {
        return Long.valueOf(this.settings.get("portfolioId"));
    }

    public void setPortfolioId(long portfolioId) {
        this.settings.put("portfolioId", "" + ClientConnection.getNewId());
    }

    public ArrayCache getIndexPrice() {
        return this.indexPrice;
    }

    public void setIndexPrice(ArrayCache indexPrice) {
        this.indexPrice = indexPrice;
    }

    public ArrayCache getIndexTimeMillisec() {
        return this.indexTimeMillisec;
    }

    public void setIndexTimeMillisec(ArrayCache indexTimeMillisec) {
        this.indexTimeMillisec = indexTimeMillisec;
    }

    public long getPriceID() {
        return this.priceID;
    }

    public void setPriceID(long priceID) {
        this.priceID = priceID;
    }

    public long getNextDataId() {
        return this.dataId++;
    }

    public HashMap<String, String> getSettings() {
        return this.settings;
    }

    public void setParam(String key, String value) {
        this.settings.put(key, value);
    }

    public String getParam(String key) {
        return this.settings.get(key);
    }

    public void setSettings(HashMap<String, String> settings) {
        this.settings = settings;
    }

    public void setSettingJSON(String JSONString) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
        this.settings = (HashMap)gson.fromJson(JSONString, mapType);
    }

    public String getSettingJSON() {
        Gson gson = new Gson();
        return gson.toJson(this.settings);
    }
}

